function moments = Model_Moments(parameters, N_variables, N_ll)
% This function computes the relevant moments of the model given the model
% parameters

global oo_

beta    = parameters(1); 
th_n_ss = parameters(2);     
th_o_ss = parameters(3);     
MS_o    = parameters(4);
lambda  = parameters(5);
eta     = parameters(6);        
R_O     = parameters(7);
gamma   = parameters(8);
L       = parameters(9);
alpha   = parameters(10);
delta   = parameters(11);
nu      = parameters(12);

epsilon = parameters(13);
rho_a1  = parameters(14);
rho_a2  = parameters(15);
u_var   = parameters(16);    
a_var   = parameters(17);     

est_par_names = {'beta', 'epsilon', 'alpha', 'eta', 'lambda', 'nu', 'delta', 'gamma'}; 
for i = 1:length(est_par_names)
    eval(['estim_param.' est_par_names{i} ' = ' est_par_names{i} ';']);
end

calib_targets.theta_n = th_n_ss;
calib_targets.theta_o = th_o_ss;
calib_targets.MS_o    = MS_o;
calib_targets.R_o     = R_O;
calib_targets.L       = L;

[struct_param, endo_ss, ~] = calibrate_ss(estim_param, calib_targets);

shock_param.rho_a1  = rho_a1;
shock_param.rho_a2  = rho_a2;
shock_param.u_var   = u_var;
shock_param.a_var   = a_var;

save calibration_parameters struct_param shock_param endo_ss


evalc('dynare World_Economy_Cartel.mod noclearall');   % Run model

Cov = oo_.var(1:N_variables, 1:N_variables); % p I_n I_o prod_n prod_o
Auto_corr = cell(N_ll, 1);
for i = 1:N_ll
    Auto_corr{i} = oo_.autocorr{i}; % lag autocorrelations
end

moments(1:N_variables) = sqrt(diag(Cov)); % std of p I_n I_o prod_n prod_o
add_count = N_variables+1;
for i = 1:N_variables-1               % cross correlations
    for j = i+1:N_variables
        moments(add_count) = Cov(i, j)/sqrt(Cov(i, i)*Cov(j, j));
        add_count = add_count + 1;
    end
end

for i = 1:N_ll
    moments(add_count:add_count+N_variables-1) = diag(Auto_corr{i}(1:N_variables, 1:N_variables)); % autocorr of p I_n I_o prod_n prod_o
    add_count = add_count+N_variables;
end

